/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen.module;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.block.entity.module.FuelModule;

public class GuiFuelModule {
    private static final ScalableElementScreen FIRE = new ScalableElementScreen(176, 136, 14, 14, 256, 256);
    private static final String TOOLTIP_TEMPERATURE = TConstruct.makeTranslationKey("gui", "melting.fuel.temperature");
    private static final List<class_2561> TOOLTIP_NO_TANK = Collections.singletonList(class_2561.method_43471((String)TConstruct.makeTranslationKey("gui", "melting.fuel.no_tank")));
    private static final List<class_2561> TOOLTIP_NO_FUEL = Collections.singletonList(class_2561.method_43471((String)TConstruct.makeTranslationKey("gui", "melting.fuel.empty")));
    private static final class_2561 TOOLTIP_INVALID_FUEL = class_2561.method_43471((String)TConstruct.makeTranslationKey("gui", "melting.fuel.invalid")).method_27692(class_124.field_1061);
    private static final class_2561 TOOLTIP_SOLID_FUEL = class_2561.method_43471((String)TConstruct.makeTranslationKey("gui", "melting.fuel.solid"));
    private final class_465<?> screen;
    private final FuelModule fuelModule;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int fireX;
    private final int fireY;
    private final boolean hasFuelSlot;
    private FuelModule.FuelInfo fuelInfo = FuelModule.FuelInfo.EMPTY;

    private boolean isHovered(int checkX, int checkY) {
        return GuiUtil.isHovered(checkX, checkY, this.x - 1, this.y - 1, this.width + 2, this.height + 2);
    }

    public void draw(class_332 graphics, class_2960 texture) {
        int fuel = this.fuelModule.getFuel();
        int fuelQuality = this.fuelModule.getFuelQuality();
        if (fuel > 0 && fuelQuality > 0) {
            FIRE.drawScaledYUp(graphics, texture, this.fireX + this.screen.field_2776, this.fireY + this.screen.field_2800, 14 * fuel / fuelQuality);
        }
        if (!this.hasFuelSlot) {
            this.fuelInfo = this.fuelModule.getFuelInfo();
            if (!this.fuelInfo.isEmpty()) {
                GuiUtil.renderFluidTank(graphics.method_51448(), this.screen, this.fuelInfo.getFluid(), this.fuelInfo.getTotalAmount(), this.fuelInfo.getCapacity(), this.x, this.y, this.width, this.height, 100);
            }
        }
    }

    public void renderHighlight(class_332 graphics, int checkX, int checkY) {
        if (this.isHovered(checkX, checkY)) {
            if (this.hasFuelSlot) {
                if (checkY > this.y + 18) {
                    GuiUtil.renderHighlight(graphics, this.x, this.y + 18, this.width, this.height - 18);
                }
            } else {
                GuiUtil.renderHighlight(graphics, this.x, this.y, this.width, this.height);
            }
        }
    }

    public void addTooltip(class_332 graphics, int mouseX, int mouseY, boolean hasTank) {
        int checkX = mouseX - this.screen.field_2776;
        int checkY = mouseY - this.screen.field_2800;
        if (this.isHovered(checkX, checkY)) {
            List<Object> tooltip;
            if (this.hasFuelSlot || this.fuelInfo.isItem()) {
                int temperature;
                tooltip = !this.hasFuelSlot || checkY > this.y + 18 ? (hasTank ? ((temperature = this.fuelModule.getTemperature()) > 0 ? Arrays.asList(TOOLTIP_SOLID_FUEL, class_2561.method_43469((String)TOOLTIP_TEMPERATURE, (Object[])new Object[]{temperature}).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})) : TOOLTIP_NO_FUEL) : TOOLTIP_NO_TANK) : Collections.emptyList();
            } else if (!this.fuelInfo.isEmpty()) {
                FluidStack fluid = this.fuelInfo.getFluid();
                tooltip = FluidTooltipHandler.getFluidTooltip(fluid, this.fuelInfo.getTotalAmount());
                int temperature = this.fuelInfo.getTemperature();
                if (temperature > 0) {
                    tooltip.add(1, class_2561.method_43469((String)TOOLTIP_TEMPERATURE, (Object[])new Object[]{temperature}).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
                } else {
                    tooltip.add(1, TOOLTIP_INVALID_FUEL);
                }
            } else {
                tooltip = hasTank ? TOOLTIP_NO_FUEL : TOOLTIP_NO_TANK;
            }
            graphics.method_51434(Screens.getTextRenderer(this.screen), tooltip, mouseX, mouseY);
        }
    }

    @Nullable
    public FluidStack getIngredient(int checkX, int checkY) {
        if (!this.hasFuelSlot && this.isHovered(checkX, checkY) && !this.fuelInfo.isEmpty()) {
            return this.fuelInfo.getFluid();
        }
        return null;
    }

    public GuiFuelModule(class_465<?> screen, FuelModule fuelModule, int x, int y, int width, int height, int fireX, int fireY, boolean hasFuelSlot) {
        this.screen = screen;
        this.fuelModule = fuelModule;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.fireX = fireX;
        this.fireY = fireY;
        this.hasFuelSlot = hasFuelSlot;
    }
}

